<?php
// Exit if accessed directly
if( !defined('ABSPATH') ) exit;

/**
 * Social Profile List Template
 * 
 * Handles to load social media connected list
 * 
 * Override this template by copying it to yourtheme/edd-social-login/edd-slg-social-profile-list.php
 * 
 * @package Easy Digital download - Social Login
 * @since 1.3.0
 */

global $edd_slg_model;

$model = $edd_slg_model; ?>

<div class="edd-slg-login-loader">
	<img src="<?php echo esc_url(EDD_SLG_IMG_URL);?>/social-loader.gif" alt="<?php echo esc_html__( 'Social Loader', 'eddslg' );?>"/>
</div>

<?php
if( isset($_SESSION['edd_slg_unlinked_notice']) && !empty($_SESSION['edd_slg_unlinked_notice'])) {
	edd_slg_success_message($_SESSION['edd_slg_unlinked_notice']);
	$_SESSION['edd_slg_unlinked_notice'] = "";
}

if( isset($_SESSION['edd_slg_linked_notice']) && !empty($_SESSION['edd_slg_linked_notice'])) {
	edd_slg_success_message($_SESSION['edd_slg_linked_notice']);
	$_SESSION['edd_slg_linked_notice'] = "";
} ?>

<div class="edd-social-login-profile edd-slg-social-wrap">
	<h2><?php
		echo esc_html__( 'My Social Login Accounts', 'eddslg' );
	?></h2><?php

	if ( $linked_profiles ) { ?>
		<p><?php
			echo $connected_link_heading;
			
			if( $can_link ) {?>
				
				<a class="edd-slg-show-link" href="javascript:void(0);"><?php echo $add_more_link; ?></a><?php 
				
			}?>
		</p>
		<div class="table-container">
		<table class="edd-social-login-linked-profiles">
			<thead>
				<tr>
					<th><?php echo esc_html__( 'Provider', 'eddslg' ); ?></th>
					<th><?php echo esc_html__( 'Account', 'eddslg' ); ?></th>
					<th><?php echo esc_html__( 'Last Login', 'eddslg' ); ?></th>
					<th><?php echo esc_html__( 'Unlink', 'eddslg' ); ?></th>
				</tr>
			</thead><?php

			foreach ( $linked_profiles as $profile => $value ) {



				$provider_icon	= EDD_SLG_IMG_URL . "/provider-icon/" . $profile . ".png";
				$provider_data	= $model->edd_slg_get_user_common_social_data( $value, $profile );	
				$provider_email = '';
				      if($provider_data['type'] == 'apple'){

				      	$provider_email = $provider_data['email'];
				      	$provider_email = empty($provider_email) ? $provider_data['all']['email'] : $provider_data['email'];

				      } else {

				      	$provider_email = !empty( $provider_data['email'] ) ? $provider_data['email'] : $provider_data['name'];
				      }


				?>
				
				<tr>
					<!-- Display provider button-->
					<td data-title="<?php esc_html__( 'Provider', 'eddslg' ); ?>">
						<div class="edd-slg-provider <?php echo $profile; ?>">
							<span class="edd-slg-provider-icon"><img src="<?php echo esc_url($provider_icon); ?>"></span><span class="edd-slg-provider-name"><?php echo $profile; ?></span>
						</div>
					</td>
					<!-- Display account email id image-->
					<td data-title="<?php esc_html__( 'Account', 'eddslg' ); ?>"><?php
						echo $provider_email;
					?></td>
					<td><?php
						$login_timestamp	= edd_slg_get_social_last_login_timestamp( $user_id, $profile );
						
						if( !empty( $login_timestamp ) ) {
							printf( esc_html__( '%s @ %s', 'eddslg' ), date_i18n( get_option( 'date_format' ), $login_timestamp ), date_i18n( get_option( 'time_format' ), $login_timestamp ) );
						} else {
							echo esc_html__( 'Never', 'eddslg' );
						}
					?></td>
					<td><?php
						if( $profile != $primary_social ) {?>
							<!-- Display profile unlink url-->
							<a href="javascript:void(0);" class="button edd-slg-social-unlink-profile" id="<?php echo $profile;?>"><?php
								echo esc_html__( 'Unlink', 'eddslg' );
							?></a><?php 
						} else {
								?>
								<!-- Display primary account unlink url-->
								<a href="javascript:void(0);" class="button edd-slg-social-unlink-profile" id=""><?php
								echo esc_html__( 'Unlink primary account', 'eddslg' );
								?></a><?php
							}
						?></td>
				</tr><?php
			}?>
			<tfoot>
				<tr>
					<th><?php echo esc_html__( 'Provider', 'eddslg' ); ?></th>
					<th><?php echo esc_html__( 'Account', 'eddslg' ); ?></th>
					<th><?php echo esc_html__( 'Last Login', 'eddslg' ); ?></th>
					<th><?php echo esc_html__( 'Unlink', 'eddslg' ); ?></th>
				</tr>
			</tfoot>
		</table></div><?php
	} else {?>

		<p><?php 
			echo $no_social_connected;
			
			if( $can_link ) {?>
				<a class="edd-slg-show-link" href="javascript:void(0);"><?php echo $connect_now_link; ?></a><?php 
			}?>
		</p><?php
	}?>

	<div class="edd-slg-profile-link-container <?php print $can_link_class;?>"><?php
		// display social link buttons
		edd_slg_link_buttons();?>

	</div>
</div>